<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

requireLogin();
header('Content-Type: application/json');

$q = isset($_GET['q']) ? trim($_GET['q']) : '';

try {
    $sql = "
        SELECT 
            q.*, 
            c.name as customer_name, 
            c.email as customer_email, 
            c.phone as customer_phone, 
            u.username as created_by_name
        FROM quotations q
        LEFT JOIN customers c ON q.customer_id = c.id
        JOIN users u ON q.created_by = u.id
        WHERE 1=1
    ";
    $params = [];
    if ($q !== '') {
        $sql .= " AND (
            q.quote_number LIKE ? OR
            c.name LIKE ? OR
            q.status LIKE ?
        )";
        $params[] = "%$q%";
        $params[] = "%$q%";
        $params[] = "%$q%";
    }
    $sql .= " ORDER BY q.created_at DESC LIMIT 50";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $quotations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'quotations' => $quotations]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 